<?php

if (! function_exists('blocksy_social_icons')) {
	function blocksy_social_icons($socials_descriptor = null, $args = []) {
		$args = wp_parse_args(
			$args,
			[
				'icons-color' => 'custom',
				'type' => 'simple',
				'size' => 'custom',
				'fill' => false,
				'hide_labels' => true,
				'links_target' => false,
				'links_rel' => false
			]
		);

		$attr = [
			'data-icon-size' => $args['size'],
			'data-color' => $args['icons-color']
		];

		// if ($args['type'] !== 'simple') {
			$attr['data-icons-type'] = $args['type'];
		// }

		if ($args['fill']) {
			if ($args['type'] !== 'simple') {
				$attr['data-icons-type'] .= ':' . $args['fill'];
			}
		}

		return blocksy_get_social_box([
			'attr' => $attr,
			'socials' => $socials_descriptor,
			'hide_labels' => $args['hide_labels'],
			'links_target' => $args['links_target'],
			'links_rel' => $args['links_rel']
		]);
	}
}

/**
 * Get social share box.
 */
if (! function_exists('blocksy_get_social_share_box')) {
	function blocksy_get_social_share_box($args = []) {
		$args = wp_parse_args(
			$args,
			[
				'html_atts' => [],
				'links_wrapper_attr' => [],
				'type' => 'type-1',
				'custom_share_url' => ''
			]
		);

		$prefix = blocksy_manager()->screen->get_prefix();

		if (! isset($args['html_atts']['data-type'])) {
			$args['html_atts']['data-type'] = $args['type'];
		}

		$before_content = '';
		$after_content = '';

		if (get_theme_mod($prefix . '_has_share_box_title', 'no') === 'yes') {
			$before_content = blocksy_html_tag(
				'span',
				[
					'class' => 'ct-module-title'
				],
				get_theme_mod(
					$prefix . '_share_box_title',
					__('Share your love', 'blocksy')
				)
			);
		}

		if ($args['type'] === 'type-1') {
			$args['links_wrapper_attr']['data-icons-type'] = 'simple';
		}

		if ($args['type'] === 'type-2') {
			$args['links_wrapper_attr']['data-icons-type'] = 'custom:solid';
		}

		return blocksy_get_social_box([
			'type' => 'share',
			'root_class' => 'ct-share-box',
			'class' => blocksy_visibility_classes(
				get_theme_mod($prefix . '_share_box_visibility', [
					'desktop' => true,
					'tablet' => true,
					'mobile' => false,
				])
			),
			// 'has_count' => $args['type'] === 'type-2',
			'attr' => $args['html_atts'],
			// 'links_wrapper' => $args['type'] === 'type-1' ? 'div' : null,
			'links_wrapper' => 'div',
			'links_wrapper_attr' => $args['links_wrapper_attr'],
			'before_links_content' => $before_content,
			'after_links_content' => $after_content,
			'custom_share_url' => $args['custom_share_url'],
			'links_rel' => get_theme_mod(
				$prefix . '_share_links_nofollow',
				'yes'
			) === 'yes' ? 'noopener noreferrer nofollow' : 'noopener'
		]);
	}
}

if (! function_exists('blocksy_get_dynamic_social_networks')) {
	function blocksy_get_dynamic_social_networks() {
		$networks = apply_filters(
			'blocksy:social-box:dynamic-social-networks',
			[]
		);

		foreach ($networks as $network) {
			blocksy_assert_args($network, ['id', 'name', 'icon']);
		}

		return $networks;
	}
}

if (! function_exists('blocksy_get_social_metadata')) {
function blocksy_get_social_metadata($args = []) {
	$args = wp_parse_args(
		$args,
		[
			// url | share
			'type' => 'url',
			'custom_url' => '',
			'social' => null,
		]
	);

	$metadata = [
		'facebook' => [
			'name' => __( 'Facebook', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Facebook Icon">
					<path d="M20,10.1c0-5.5-4.5-10-10-10S0,4.5,0,10.1c0,5,3.7,9.1,8.4,9.9v-7H5.9v-2.9h2.5V7.9C8.4,5.4,9.9,4,12.2,4c1.1,0,2.2,0.2,2.2,0.2v2.5h-1.3c-1.2,0-1.6,0.8-1.6,1.6v1.9h2.8L13.9,13h-2.3v7C16.3,19.2,20,15.1,20,10.1z"/>
				</svg>
			',
		],

		'twitter' => [
			'name' => __( 'Twitter', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Twitter Icon">
					<path d="M20,3.8c-0.7,0.3-1.5,0.5-2.4,0.6c0.8-0.5,1.5-1.3,1.8-2.3c-0.8,0.5-1.7,0.8-2.6,1c-0.7-0.8-1.8-1.3-3-1.3c-2.3,0-4.1,1.8-4.1,4.1c0,0.3,0,0.6,0.1,0.9C6.4,6.7,3.4,5.1,1.4,2.6C1,3.2,0.8,3.9,0.8,4.7c0,1.4,0.7,2.7,1.8,3.4C2,8.1,1.4,7.9,0.8,7.6c0,0,0,0,0,0.1c0,2,1.4,3.6,3.3,4c-0.3,0.1-0.7,0.1-1.1,0.1c-0.3,0-0.5,0-0.8-0.1c0.5,1.6,2,2.8,3.8,2.8c-1.4,1.1-3.2,1.8-5.1,1.8c-0.3,0-0.7,0-1-0.1c1.8,1.2,4,1.8,6.3,1.8c7.5,0,11.7-6.3,11.7-11.7c0-0.2,0-0.4,0-0.5C18.8,5.3,19.4,4.6,20,3.8z"/>
				</svg>
			',
		],

		'instagram' => [
			'name' => __( 'Instagram', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Instagram Icon">
					<circle cx="10" cy="10" r="3.3"/>
					<path d="M14.2,0H5.8C2.6,0,0,2.6,0,5.8v8.3C0,17.4,2.6,20,5.8,20h8.3c3.2,0,5.8-2.6,5.8-5.8V5.8C20,2.6,17.4,0,14.2,0zM10,15c-2.8,0-5-2.2-5-5s2.2-5,5-5s5,2.2,5,5S12.8,15,10,15z M15.8,5C15.4,5,15,4.6,15,4.2s0.4-0.8,0.8-0.8s0.8,0.4,0.8,0.8S16.3,5,15.8,5z"/>
				</svg>
			'
		],

		'pinterest' => [
			'name' => __( 'Pinterest', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Pinterest Icon">
					<path d="M10,0C4.5,0,0,4.5,0,10c0,4.1,2.5,7.6,6,9.2c0-0.7,0-1.5,0.2-2.3c0.2-0.8,1.3-5.4,1.3-5.4s-0.3-0.6-0.3-1.6c0-1.5,0.9-2.6,1.9-2.6c0.9,0,1.3,0.7,1.3,1.5c0,0.9-0.6,2.3-0.9,3.5c-0.3,1.1,0.5,1.9,1.6,1.9c1.9,0,3.2-2.4,3.2-5.3c0-2.2-1.5-3.8-4.2-3.8c-3,0-4.9,2.3-4.9,4.8c0,0.9,0.3,1.5,0.7,2C6,12,6.1,12.1,6,12.4c0,0.2-0.2,0.6-0.2,0.8c-0.1,0.3-0.3,0.3-0.5,0.3c-1.4-0.6-2-2.1-2-3.8c0-2.8,2.4-6.2,7.1-6.2c3.8,0,6.3,2.8,6.3,5.7c0,3.9-2.2,6.9-5.4,6.9c-1.1,0-2.1-0.6-2.4-1.2c0,0-0.6,2.3-0.7,2.7c-0.2,0.8-0.6,1.5-1,2.1C8.1,19.9,9,20,10,20c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0z"/>
				</svg>
			',
		],

		'dribbble' => [
			'name' => __( 'Dribbble', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Dribbble Icon">
					<path d="M10,0C4.5,0,0,4.5,0,10c0,5.5,4.5,10,10,10c5.5,0,10-4.5,10-10C20,4.5,15.5,0,10,0 M16.1,5.2c1,1.2,1.6,2.8,1.7,4.4c-1.1-0.2-2.2-0.4-3.2-0.4v0h0c-0.8,0-1.6,0.1-2.3,0.2c-0.2-0.4-0.3-0.8-0.5-1.2C13.4,7.6,14.9,6.6,16.1,5.2 M10,2.2c1.8,0,3.5,0.6,4.9,1.7c-1,1.2-2.4,2.1-3.8,2.7c-1-2-2-3.4-2.7-4.3C8.9,2.3,9.4,2.2,10,2.2 M6.6,3c0.5,0.6,1.6,2,2.8,4.2C7,8,4.6,8.1,3.2,8.1c0,0-0.1,0-0.1,0h0c-0.2,0-0.4,0-0.6,0C3,5.9,4.5,4,6.6,3 M2.2,10c0,0,0-0.1,0-0.1c0.2,0,0.5,0,0.9,0h0c1.6,0,4.3-0.1,7.1-1c0.2,0.3,0.3,0.7,0.4,1c-1.9,0.6-3.3,1.6-4.4,2.6c-1,0.9-1.7,1.9-2.2,2.5C2.9,13.7,2.2,11.9,2.2,10 M10,17.8c-1.7,0-3.3-0.6-4.6-1.5c0.3-0.5,0.9-1.3,1.8-2.2c1-0.9,2.3-1.9,4.1-2.5c0.6,1.7,1.1,3.6,1.5,5.7C11.9,17.6,11,17.8,10,17.8M14.4,16.4c-0.4-1.9-0.9-3.7-1.4-5.2c0.5-0.1,1-0.1,1.6-0.1h0h0h0c0.9,0,2,0.1,3.1,0.4C17.3,13.5,16.1,15.3,14.4,16.4"/>
				</svg>
			'
		],

		'behance' => [
			'name' => __( 'Behance', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Behance Icon">
					<path d="M15.2,10.3h-2.7c0,0,0.2-1.3,1.5-1.3C15.2,9,15.2,10.3,15.2,10.3z M7.7,10.3H5.3v2.2h2.2c0,0,0.1,0,0.2,0c0.3,0,1-0.1,1-1.1C8.6,10.3,7.7,10.3,7.7,10.3zM20,10c0,5.5-4.5,10-10,10C4.5,20,0,15.5,0,10S4.5,0,10,0C15.5,0,20,4.5,20,10zM12.1,7.2h3.4v-1h-3.4V7.2z M8.8,9.5c0,0,1.3-0.1,1.3-1.6S9,5.7,7.7,5.7H5.3H5.2H3.4V14h1.8h0.1h2.4c0,0,2.6,0.1,2.6-2.5C10.4,11.5,10.5,9.5,8.8,9.5zM13.9,7.8c-3.2,0-3.2,3.2-3.2,3.2s-0.2,3.2,3.2,3.2c0,0,2.9,0.2,2.9-2.2h-1.5c0,0,0,0.9-1.3,0.9c0,0-1.5,0.1-1.5-1.5h4.3C16.8,11.4,17.3,7.8,13.9,7.8z M8.3,8c0-0.9-0.6-0.9-0.6-0.9H7.4H5.3V9h2.3C8,9,8.3,8.9,8.3,8z"/>
				</svg>
			'
		],

		'unsplash' => [
			'name' => __( 'Unsplash', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Unsplash Icon">
					<path d="M6.2 5.6V0h7.5v5.6H6.2zm7.6 3.2H20V20H0V8.8h6.2v5.6h7.5V8.8z"/>
				</svg>
			'
		],

		'five-hundred-px' => [
			'name' => __( '500px', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="500PX Icon">
					<path d="M17.7 17.3c-.9.9-1.9 1.6-3 2-1.1.5-2.3.7-3.5.7-1.2 0-2.4-.2-3.5-.7-1.1-.5-2.1-1.1-2.9-2-.8-.8-1.5-1.8-2-2.9-.3-.8-.5-1.5-.6-2.1 0-.2.1-.3.5-.4.4-.1.6 0 .6.2.1.7.3 1.3.5 1.8.4.9.9 1.8 1.7 2.5.7.7 1.6 1.3 2.5 1.7 1 .4 2 .6 3.1.6s2.1-.2 3.1-.6c1-.4 1.8-1 2.5-1.7l.1-.1c.1-.1.2-.1.3-.1.1 0 .2.1.4.2.3.5.3.7.2.9zm-5.3-6.9l-.7.7.7.7c.2.2.1.3-.1.5-.1.1-.2.2-.4.2-.1 0-.1 0-.2-.1l-.7-.7-.7.7s-.1.1-.2.1-.2-.1-.3-.2c-.1-.1-.2-.2-.2-.3 0-.1 0-.1.1-.2l.7-.7-.7-.7c-.1-.1-.1-.3.2-.5.1-.1.2-.2.3-.2 0 0 .1 0 .1.1l.7.7.7-.7c.1-.1.3-.1.5.1.3.2.4.4.2.5zm5.3.6c0 .9-.2 1.7-.5 2.5s-.8 1.5-1.4 2.1c-.6.6-1.3 1.1-2.1 1.4-.8.3-1.6.5-2.5.5-.9 0-1.7-.2-2.5-.5s-1.5-.8-2.1-1.4c-.6-.6-1.1-1.3-1.4-2.1l-.2-.4c-.1-.2.1-.4.5-.5.4-.1.6-.1.7.1.3.7.6 1.4 1.1 1.9v-3.8c0-1 .4-1.9 1.1-2.6.8-.8 1.7-1.1 2.8-1.1 1.1 0 2 .4 2.8 1.1.8.8 1.2 1.7 1.2 2.8 0 1.1-.4 2-1.2 2.8-.8.8-1.7 1.2-2.8 1.2-.4 0-.8-.1-1.2-.2-.2-.1-.3-.3-.1-.7.1-.4.3-.5.5-.5h.2c.1 0 .2 0 .4.1s.3 0 .3 0c.8 0 1.4-.3 2-.8.5-.5.8-1.2.8-1.9 0-.8-.3-1.4-.8-1.9s-1.2-.8-2-.8-1.5.3-2 .9c-.7.6-.9 1.2-.9 1.8v4.6c.8.5 1.7.7 2.7.7.7 0 1.4-.1 2.1-.4.7-.3 1.2-.7 1.7-1.2s.9-1.1 1.2-1.7c.3-.7.4-1.3.4-2 0-1.5-.5-2.7-1.6-3.8-1-1-2.3-1.6-3.8-1.6s-2.8.5-3.8 1.6c-.4.4-.7.8-.8 1l-.2.2s-.1.1-.2.1h-.4c-.2 0-.3-.1-.4-.2S5 8.1 5 8V.4c0-.1 0-.2.1-.3s.2-.1.4-.1h9.8c.2 0 .3.2.3.6s-.1.6-.3.6H6.2v5.4c.3-.3.7-.6 1.2-.9.4-.3.8-.6 1.2-.7.8-.3 1.7-.5 2.6-.5.9 0 1.7.2 2.5.5s1.5.8 2.1 1.4c.6.6 1.1 1.3 1.4 2.1.3.8.5 1.7.5 2.5zm-.4-6.4c.1.1.1.1.1.2s0 .1-.1.2l-.2.2c-.2.2-.3.3-.4.3-.1 0-.1 0-.2-.1-.8-.7-1.6-1.2-2.3-1.5-1-.4-2-.6-3.1-.6-1 0-2 .2-2.9.5-.1.1-.3 0-.4-.4-.1-.2-.1-.3-.1-.4 0-.1.1-.2.2-.2 1-.4 2.1-.6 3.3-.6 1.2 0 2.4.2 3.5.7 1 .4 1.9 1 2.6 1.7z"/>
				</svg>
			'
		],

		'linkedin' => [
			'name' => __( 'LinkedIn', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="LinkedIn Icon">
					<path d="M18.6,0H1.4C0.6,0,0,0.6,0,1.4v17.1C0,19.4,0.6,20,1.4,20h17.1c0.8,0,1.4-0.6,1.4-1.4V1.4C20,0.6,19.4,0,18.6,0z M6,17.1h-3V7.6h3L6,17.1L6,17.1zM4.6,6.3c-1,0-1.7-0.8-1.7-1.7s0.8-1.7,1.7-1.7c0.9,0,1.7,0.8,1.7,1.7C6.3,5.5,5.5,6.3,4.6,6.3z M17.2,17.1h-3v-4.6c0-1.1,0-2.5-1.5-2.5c-1.5,0-1.8,1.2-1.8,2.5v4.7h-3V7.6h2.8v1.3h0c0.4-0.8,1.4-1.5,2.8-1.5c3,0,3.6,2,3.6,4.5V17.1z"/>
				</svg>
			',
		],

		'wordpress' => [
			'name' => __( 'WordPress', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="WordPress Icon">
					<path d="M1.9 4.1C3.7 1.6 6.7 0 10 0c2.4 0 4.6.9 6.3 2.3-.7.2-1.2 1-1.2 1.7 0 .9.5 1.6 1 2.4.5.7.9 1.6.9 2.9 0 .9-.3 2-.8 3.4l-1 3.5-3.8-11.3c.6 0 1.2-.1 1.2-.1.6 0 .5-.8 0-.8 0 0-1.7.1-2.8.1-1 0-2.7-.1-2.7-.1-.6 0-.7.8-.1.8 0 0 .5.1 1.1.1l1.6 4.4-2.3 6.8L3.7 4.9c.6 0 1.2-.1 1.2-.1.5 0 .4-.8-.1-.8 0 0-1.7.1-2.9.1.1 0 .1 0 0 0zM.8 6.2C.3 7.4 0 8.6 0 10c0 3.9 2.2 7.2 5.4 8.9L.8 6.2zm9.4 4.5l-3 8.9c.9.3 1.8.4 2.8.4 1.2 0 2.3-.2 3.4-.6l-3.2-8.7zm9-4.6c0 1-.2 2.2-.8 3.6l-3 8.8c2.8-1.8 4.6-4.9 4.6-8.4 0-1.5-.3-2.8-.8-4z"/>
				</svg>
			',
		],

		'parler' => [
			'name' => __( 'Parler', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Parler Icon">
					<path d="M11.7,16.7h-5V15c0-0.9,0.7-1.6,1.6-1.6h3.4c2.8,0,5-2.2,5-5s-2.2-5-5-5h0l-1.1,0H0C0,1.5,1.5,0,3.3,0h7.3l1.1,0C16.3,0,20,3.8,20,8.4S16.3,16.7,11.7,16.7z M3.3,20C1.5,20,0,18.5,0,16.7V9.9c0-1.8,1.4-3.2,3.2-3.2h8.4c0.9,0,1.7,0.7,1.7,1.7c0,0.9-0.7,1.7-1.7,1.7H5c-0.9,0-1.6,0.7-1.6,1.6V20z"/>
				</svg>
			',
		],

		'mastodon' => [
			'name' => __( 'Mastodon', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Mastodon Icon">
					<path d="M19.3 6.6c0-4.3-2.8-5.6-2.8-5.6C13.7-.3 6.3-.3 3.5 1 3.5 1 .7 2.3.7 6.6c0 5.2-.3 11.6 4.7 12.9 1.8.5 3.4.6 4.6.5 2.3-.1 3.5-.8 3.5-.8l-.1-1.6s-1.6.5-3.4.5c-1.8-.1-3.7-.2-4-2.4v-.6c3.8.9 7.1.4 8 .3 2.5-.3 4.7-1.8 5-3.3.4-2.3.3-5.5.3-5.5zM16 12.2h-2.1V7.1c0-2.2-2.9-2.3-2.9.3v2.8H9V7.4c0-2.6-2.9-2.5-2.9-.3v5.1H4c0-5.4-.2-6.6.8-7.8C6 3.1 8.4 3 9.5 4.6l.5.9.5-.9c1.1-1.6 3.5-1.5 4.7-.3 1 1.3.8 2.4.8 7.9z"/>
				</svg>
			',
		],

		'medium' => [
			'name' => __( 'Medium', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Medium Icon">
					<path d="M2.4,5.3c0-0.2-0.1-0.5-0.3-0.7L0.3,2.4V2.1H6l4.5,9.8l3.9-9.8H20v0.3l-1.6,1.5c-0.1,0.1-0.2,0.3-0.2,0.4v11.2c0,0.2,0,0.3,0.2,0.4l1.6,1.5v0.3h-7.8v-0.3l1.6-1.6c0.2-0.2,0.2-0.2,0.2-0.4V6.5L9.4,17.9H8.8L3.6,6.5v7.6c0,0.3,0.1,0.6,0.3,0.9L6,17.6v0.3H0v-0.3L2.1,15c0.2-0.2,0.3-0.6,0.3-0.9V5.3z"/>
				</svg>
			'
		],

		'slack' => [
			'name' => __( 'Slack', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Slack Icon">
					<path d="M7.4,0C6.2,0,5.2,1,5.2,2.2s1,2.2,2.2,2.2h2.2V2.2C9.6,1,8.6,0,7.4,0zM12.6,0c-1.2,0-2.2,1-2.2,2.2v5.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2V2.2C14.8,1,13.8,0,12.6,0z M2.2,5.2C1,5.2,0,6.2,0,7.4s1,2.2,2.2,2.2h5.2c1.2,0,2.2-1,2.2-2.2s-1-2.2-2.2-2.2H2.2zM17.8,5.2c-1.2,0-2.2,1-2.2,2.2v2.2h2.2c1.2,0,2.2-1,2.2-2.2S19,5.2,17.8,5.2z M2.2,10.4c-1.2,0-2.2,1-2.2,2.2s1,2.2,2.2,2.2s2.2-1,2.2-2.2v-2.2H2.2zM7.4,10.4c-1.2,0-2.2,1-2.2,2.2v5.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2v-5.2C9.6,11.4,8.6,10.4,7.4,10.4z M12.6,10.4c-1.2,0-2.2,1-2.2,2.2s1,2.2,2.2,2.2h5.2c1.2,0,2.2-1,2.2-2.2s-1-2.2-2.2-2.2H12.6zM10.4,15.7v2.2c0,1.2,1,2.2,2.2,2.2s2.2-1,2.2-2.2c0-1.2-1-2.2-2.2-2.2H10.4z"/>
				</svg>
			'
		],

		'codepen' => [
			'name' => __( 'CodePen', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="CodePen Icon">
					<path d="M10,0L0,6.4v7.3L10,20l10-6.4V6.4L10,0z M10,12l-2.8-2L10,8.1l2.8,1.9L10,12z M11,6.5V2.8l6.4,4.1l-2.9,2L11,6.5z M9,6.5L5.5,8.9l-2.9-2L9,2.8V6.5z M3.9,10l-1.9,1.3V8.7L3.9,10z M5.5,11.2L9,13.6v3.5l-6.4-4.1L5.5,11.2z M11,13.6l3.5-2.5l2.8,1.9L11,17.2V13.6z M16.1,10l1.9-1.4v2.7L16.1,10z"/>
				</svg>
			'
		],

		'reddit' => [
			'name' => __( 'Reddit', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Reddit Icon">
					<path d="M11.7,0.9c-0.9,0-2,0.7-2.1,3.9c0.1,0,0.3,0,0.4,0c0.2,0,0.3,0,0.5,0c0.1-1.9,0.6-3.1,1.3-3.1c0.3,0,0.5,0.2,0.8,0.5c0.4,0.4,0.9,0.9,1.8,1.1c0-0.1,0-0.2,0-0.4c0-0.2,0-0.4,0.1-0.5c-0.6-0.2-0.9-0.5-1.2-0.8C12.8,1.3,12.4,0.9,11.7,0.9z M16.9,1.3c-1,0-1.7,0.8-1.7,1.7s0.8,1.7,1.7,1.7s1.7-0.8,1.7-1.7S17.9,1.3,16.9,1.3z M10,5.7c-5.3,0-9.5,2.7-9.5,6.5s4.3,6.9,9.5,6.9s9.5-3.1,9.5-6.9S15.3,5.7,10,5.7z M2.4,6.1c-0.6,0-1.2,0.3-1.7,0.7C0,7.5-0.2,8.6,0.2,9.5C0.9,8.2,2,7.1,3.5,6.3C3.1,6.2,2.8,6.1,2.4,6.1z M17.6,6.1c-0.4,0-0.7,0.1-1.1,0.3c1.5,0.8,2.6,1.9,3.2,3.2c0.4-0.9,0.3-2-0.5-2.7C18.8,6.3,18.2,6.1,17.6,6.1z M6.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S5.8,9.6,6.5,9.6z M13.5,9.6c0.7,0,1.3,0.6,1.3,1.3s-0.6,1.3-1.3,1.3s-1.3-0.6-1.3-1.3S12.8,9.6,13.5,9.6z M6.1,14.3c0.1,0,0.2,0.1,0.3,0.2c0,0.1,1.1,1.4,3.6,1.4c2.6,0,3.6-1.4,3.6-1.4c0.1-0.2,0.4-0.2,0.6-0.1c0.2,0.1,0.2,0.4,0.1,0.6c-0.1,0.1-1.3,1.8-4.3,1.8c-3,0-4.2-1.7-4.3-1.8c-0.1-0.2-0.1-0.5,0.1-0.6C5.9,14.4,6,14.3,6.1,14.3z"/>
				</svg>
			',
		],

		'twitch' => [
			'name' => __( 'Twitch', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Twitch Icon">
					<path d="M1.5,0L0,4.1v12.8h4.6V20h2.1l3.8-3.1h4.1l5.4-5.8V0H1.5zM3.1,1.5h15.4v8.8l-3.3,3.5H9.5l-3.4,2.9v-2.9H3.1V1.5z M7.7,4.6v6.2h1.5V4.6H7.7z M12.3,4.6v6.2h1.5V4.6H12.3z"/>
				</svg>
			',
		],

		'tiktok' => [
			'name' => __( 'TikTok', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="TikTok Icon">
					<path d="M18.2 4.5c-2.3-.2-4.1-1.9-4.4-4.2V0h-3.4v13.8c0 1.4-1.2 2.6-2.8 2.6-1.4 0-2.6-1.1-2.6-2.6s1.1-2.6 2.6-2.6h.2l.5.1V7.5h-.7c-3.4 0-6.2 2.8-6.2 6.2S4.2 20 7.7 20s6.2-2.8 6.2-6.2v-7c1.1 1.1 2.4 1.6 3.9 1.6h.8V4.6l-.4-.1z"/>
				</svg>
			',
		],

		'snapchat' => [
			'name' => __( 'Snapchat', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Snapchat Icon">
					<path d="M10,0.5c-6,0-6,6-6,6v1c0,0,0,0-0.1,0C3.6,7.5,2,7.6,2,8.9c0,1.5,1.7,1.6,2,1.6c0,0,0,0,0,0c0,1-1.7,2.2-2.7,2.4C0.3,13.3,0,14,0,14.5c0,0.3,0.1,0.5,0.1,0.6c0.4,0.9,1.5,1.3,2.6,1.3c0,1.4,1.1,2,1.8,2c0.8,0,1.6-0.4,1.6-0.4c0,0,1.3,1.4,3.9,1.4s3.9-1.4,3.9-1.4c0,0,0.8,0.4,1.6,0.4c0.7,0,1.7-0.6,1.8-2c1.1,0,2.2-0.5,2.6-1.3c0-0.1,0.1-0.3,0.1-0.6c0-0.5-0.3-1.2-1.3-1.6c-1.1-0.3-2.7-1.4-2.7-2.4c0,0,0,0,0,0c0.3,0,2-0.1,2-1.6c0-1.3-1.6-1.4-1.9-1.4c0,0-0.1,0-0.1,0v-1C16,6.5,16,0.5,10,0.5L10,0.5z"/>
				</svg>
			',
		],

		'spotify' => [
			'name' => __( 'Spotify', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Spotify Icon">
					<path d="M10,0C4.5,0,0,4.5,0,10s4.5,10,10,10s10-4.5,10-10S15.5,0,10,0z M14.2,14.5c-0.1,0.2-0.3,0.3-0.5,0.3c-0.1,0-0.2,0-0.4-0.1c-1.1-0.7-2.9-1.2-4.4-1.2c-1.6,0-2.8,0.4-2.8,0.4c-0.3,0.1-0.7-0.1-0.8-0.4c-0.1-0.3,0.1-0.7,0.4-0.8c0.1,0,1.4-0.5,3.2-0.5c1.5,0,3.6,0.4,5.1,1.4C14.4,13.8,14.4,14.2,14.2,14.5z M15.5,11.8c-0.1,0.2-0.4,0.4-0.6,0.4c-0.1,0-0.3,0-0.4-0.1c-1.9-1.2-4-1.5-5.7-1.5c-1.9,0-3.5,0.4-3.5,0.4c-0.4,0.1-0.8-0.1-0.9-0.5c-0.1-0.4,0.1-0.8,0.5-0.9c0.1,0,1.7-0.4,3.8-0.4c1.9,0,4.4,0.3,6.6,1.7C15.6,11,15.8,11.5,15.5,11.8z M16.8,8.7c-0.2,0.3-0.5,0.4-0.8,0.4c-0.1,0-0.3,0-0.4-0.1c-2.3-1.3-5-1.6-6.9-1.6c0,0,0,0,0,0c-2.3,0-4.1,0.4-4.1,0.4c-0.5,0.1-0.9-0.2-1-0.6c-0.1-0.5,0.2-0.9,0.6-1c0.1,0,2-0.5,4.5-0.5c0,0,0,0,0,0c2.1,0,5.2,0.3,7.8,1.9C16.9,7.8,17.1,8.3,16.8,8.7z"/>
				</svg>
			',
		],

		'soundcloud' => [
			'name' => __( 'SoundCloud', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="SoundCloud Icon">
					<path d="M20 12.7c0 1.5-1.2 2.7-2.7 2.7h-6c-.4 0-.7-.3-.7-.7V5.3c0-.4.3-.7.7-.7h.7c3.3 0 6 2.7 4.7 5.3h.7c1.4.1 2.6 1.3 2.6 2.8zM.7 9.9c-.4 0-.7.3-.7.7v4.1c0 .4.3.7.7.7.4 0 .7-.3.7-.7v-4.1c-.1-.4-.4-.7-.7-.7zM6 5.3c-.4 0-.7.3-.7.7v8.7c0 .4.3.7.7.7s.7-.3.7-.7V6c0-.4-.3-.7-.7-.7zm2.7 2c-.4 0-.7.3-.7.7v6.7c0 .4.3.7.7.7.4 0 .7-.3.7-.7V8c-.1-.4-.4-.7-.7-.7zM3.3 8c-.3 0-.6.3-.6.7v6c0 .4.3.7.7.7.3-.1.6-.4.6-.7v-6c0-.4-.3-.7-.7-.7z"/>
				</svg>
			',
		],

		'apple_podcast' => [
			'name' => __( 'Apple Podcasts', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Apple Podcasts Icon">
					<path d="M10 0C5.1 0 1.1 4 1.1 8.9c0 2.9 1.4 5.5 3.6 7.1.3.2.5.4.8.5.3.2.8.1 1-.2.2-.3.1-.8-.2-1-.2-.1-.5-.3-.7-.5-1.8-1.4-3-3.6-3-6 0-4.2 3.4-7.5 7.5-7.5s7.5 3.4 7.5 7.5c0 2.5-1.2 4.7-3 6-.2.2-.5.3-.7.5-.3.2-.5.6-.3 1 .2.3.6.5 1 .3.3-.2.6-.4.8-.6 2.2-1.6 3.6-4.2 3.6-7.2C18.9 4 14.9 0 10 0zm0 2.8c-3.4 0-6.1 2.7-6.1 6.1 0 1.7.7 3.2 1.8 4.3.3.3.7.3 1 0s.3-.7 0-1c-.9-.9-1.4-2-1.4-3.3 0-2.6 2.1-4.7 4.7-4.7s4.7 2.1 4.7 4.7c0 1.3-.5 2.5-1.4 3.3-.3.3-.3.7 0 1 .3.3.7.3 1 0 1.1-1.1 1.8-2.6 1.8-4.3 0-3.3-2.7-6.1-6.1-6.1zm0 3.8C8.7 6.6 7.6 7.7 7.6 9s1.1 2.4 2.4 2.4 2.4-1.1 2.4-2.4-1.1-2.4-2.4-2.4zm0 5.6c-1.3 0-2.4 1.1-2.4 2.4v.5l.9 3.7c.2.7.8 1.2 1.5 1.2s1.3-.5 1.4-1.1l.9-3.7v-.1-.4c.1-1.4-1-2.5-2.3-2.5z"/>
				</svg>
			',
		],

		'patreon' => [
			'name' => __( 'Patreon', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Patreon Icon">
					<path d="M20,7.6c0,4-3.2,7.2-7.2,7.2c-4,0-7.2-3.2-7.2-7.2c0-4,3.2-7.2,7.2-7.2C16.8,0.4,20,3.6,20,7.6z M0,19.6h3.5V0.4H0V19.6z"/>
				</svg>
			'
		],

		'alignable' => [
			'name' => __( 'Alignable', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Alignable Icon">
					<path d="M19.5 6.7C18.1 2.8 14.3 0 9.9 0c-.7 0-1.4.1-2.1.3L6.6.6c.1.1.1.3.2.4.2.8.5 1.6.7 2.4.2.4.4.9.5 1.4.5 1.5 1.1 2.8 1.7 3.8.2.4.5.8.8 1.1.4.4.8.7 1.3.7.7 0 1.3-.6 1.9-1.4.5 1 1.1 2.3 1.5 3.5-.9.8-2 1.3-3.3 1.3-1 0-1.8-.3-2.6-.8-.3-.2-.7-.5-1-.8-1-.9-1.7-2.2-2.4-3.6-.3-.5-.5-1-.7-1.6C4.5 5.5 4 3.9 3.6 2.3c-.4.2-.7.6-1 .9C1 5 0 7.4 0 10c0 2.3.7 4.4 2 6.1.2.4.6.8.9 1.1.3-1.1.7-2.1 1-3.1.4-1.3.8-2.6 1.3-3.9.7 1.3 1.5 2.5 2.5 3.3-.2.6-.4 1.2-.6 1.7-.5 1.3-.9 2.7-1.4 4 .4.1.8.3 1.2.4 1 .3 2 .4 3 .4 2.7 0 5.2-1.1 7-2.8.4-.4.7-.7 1-1.1-.1-.3-.2-.7-.3-1-.3-.7-.5-1.5-.8-2.3-.2-.5-.3-.9-.5-1.4-.5-1.5-1.1-2.8-1.7-3.8-.2-.4-.5-.8-.8-1.1l-.3-.3c-.3-.3-.7-.4-1-.4-.7 0-1.3.6-1.9 1.4-.6-1-1.2-2.3-1.6-3.5.1-.1.2-.2.4-.3.9-.6 1.9-1 3-1 1 0 1.8.3 2.6.8.3.2.7.5 1 .8.9.9 1.7 2.2 2.3 3.5.3.5.5 1.1.7 1.6.3.7.6 1.4.8 2.1.2-.4.2-.8.2-1.2 0-1.1-.2-2.2-.5-3.3z"/>
				</svg>
			'
		],

		'skype' => [
			'name' => __( 'Skype', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Skype Icon">
					<path d="M5.7 0C2.6 0 0 2.5 0 5.6c0 1 .2 1.9.7 2.7-.1.6-.2 1.2-.2 1.8 0 5.2 4.3 9.4 9.6 9.4.5 0 1.1 0 1.6-.1.8.4 1.7.6 2.6.6 3.1 0 5.7-2.5 5.7-5.6 0-.8-.2-1.6-.5-2.4.1-.6.2-1.2.2-1.9 0-5.2-4.3-9.4-9.6-9.4-.5 0-1 0-1.5.1C7.7.3 6.7 0 5.7 0zM10 3.8c.8 0 1.5.1 2.1.3.6.2 1.1.4 1.5.7.4.3.7.6.9 1 .2.3.3.7.3 1 0 .3-.1.6-.4.9s-.5.3-.8.3c-.3 0-.6-.1-.8-.2-.2-.2-.4-.4-.6-.7-.2-.4-.5-.8-.8-1-.3-.2-.8-.3-1.5-.3s-1.2.1-1.6.4c-.4.2-.6.5-.6.8 0 .2.1.4.2.5.1.2.3.3.5.4.3.1.5.2.8.3.3.1.7.2 1.3.3.7.2 1.4.3 2 .5.6.2 1.1.4 1.6.7.4.3.8.6 1 1.1s.4 1 .4 1.6c0 .7-.2 1.4-.6 2-.4.6-1.1 1.1-1.9 1.4-.8.3-1.8.5-2.9.5-1.3 0-2.4-.2-3.3-.7-.6-.3-1.1-.8-1.5-1.3-.4-.6-.6-1.1-.6-1.6 0-.3.1-.6.4-.9.3-.2.6-.3.9-.3.3 0 .6.1.8.3.2.2.4.4.5.8.2.4.3.7.5.9.2.2.4.4.8.6.3.2.8.2 1.3.2.8 0 1.4-.2 1.8-.5.5-.3.7-.7.7-1.1 0-.4-.1-.6-.4-.9-.2-.2-.6-.4-1-.5-.4-.1-1-.3-1.7-.4-.9-.2-1.8-.4-2.4-.7-.4-.3-1-.7-1.3-1.2-.4-.5-.7-1.1-.7-1.8s.2-1.3.6-1.8c.4-.5 1-.9 1.8-1.2.8-.3 1.7-.4 2.7-.4z"/>
				</svg>
			'
		],

		'github' => [
			'name' => __( 'GitHub', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="GitHub Icon">
					<path d="M8.9,0.4C4.3,0.9,0.6,4.6,0.1,9.1c-0.5,4.7,2.2,8.9,6.3,10.5C6.7,19.7,7,19.5,7,19.1v-1.6c0,0-0.4,0.1-0.9,0.1c-1.4,0-2-1.2-2.1-1.9c-0.1-0.4-0.3-0.7-0.6-1C3.1,14.6,3,14.6,3,14.5c0-0.2,0.3-0.2,0.4-0.2c0.6,0,1.1,0.7,1.3,1c0.5,0.8,1.1,1,1.4,1c0.4,0,0.7-0.1,0.9-0.2c0.1-0.7,0.4-1.4,1-1.8c-2.3-0.5-4-1.8-4-4c0-1.1,0.5-2.2,1.2-3C5.1,7.1,5,6.6,5,5.9c0-0.4,0-1,0.3-1.6c0,0,1.4,0,2.8,1.3C8.6,5.4,9.3,5.3,10,5.3s1.4,0.1,2,0.3c1.3-1.3,2.8-1.3,2.8-1.3C15,4.9,15,5.5,15,5.9c0,0.8-0.1,1.2-0.2,1.4c0.7,0.8,1.2,1.8,1.2,3c0,2.2-1.7,3.5-4,4c0.6,0.5,1,1.4,1,2.3v2.6c0,0.3,0.3,0.6,0.7,0.5c3.7-1.5,6.3-5.1,6.3-9.3C20,4.4,14.9-0.3,8.9,0.4z"/>
				</svg>
			'
		],

		'gitlab' => [
			'name' => __( 'GitLab', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="GitLab Icon">
					<path d="M15.7.9c-.2 0-.4.1-.4.3l-2.2 6.7H6.9L4.8 1.2C4.7 1 4.5.9 4.4.9c-.2 0-.4.1-.5.3l-2.6 7L0 11.6c0 .2 0 .4.2.5l9.6 7h.1l9.6-7c.5-.1.5-.3.5-.5l-1.3-3.5-2.6-7c-.1-.1-.3-.2-.4-.2zM2.6 8.7h3.7l2.5 7.8-6.2-7.8zm11.1 0h3.7l-6.2 7.8 2.5-7.8zm-11.8.4l5.8 7.3L1 11.6l.9-2.5zm16.2 0l.9 2.4-6.7 4.9 5.8-7.3z"/>
				</svg>
			'
		],

		'youtube' => [
			'name' => __( 'YouTube', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewbox="0 0 20 20"
				aria-label="YouTube Icon">
					<path d="M15,0H5C2.2,0,0,2.2,0,5v10c0,2.8,2.2,5,5,5h10c2.8,0,5-2.2,5-5V5C20,2.2,17.8,0,15,0z M14.5,10.9l-6.8,3.8c-0.1,0.1-0.3,0.1-0.5,0.1c-0.5,0-1-0.4-1-1l0,0V6.2c0-0.5,0.4-1,1-1c0.2,0,0.3,0,0.5,0.1l6.8,3.8c0.5,0.3,0.7,0.8,0.4,1.3C14.8,10.6,14.6,10.8,14.5,10.9z"/>
				</svg>
			'
		],

		'vimeo' => [
			'name' => __( 'Vimeo', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Vimeo Icon">
					<path d="M20,5.3c-0.1,1.9-1.4,4.6-4.1,8c-2.7,3.5-5,5.3-6.9,5.3c-1.2,0-2.2-1.1-3-3.2C4.5,9.7,3.8,6.3,2.5,6.3c-0.2,0-0.7,0.3-1.6,0.9L0,6c2.3-2,4.5-4.3,5.9-4.4c1.6-0.2,2.5,0.9,2.9,3.2c1.3,8.1,1.8,9.3,4.2,5.7c0.8-1.3,1.3-2.3,1.3-3c0.2-2-1.6-1.9-2.8-1.4c1-3.2,2.9-4.8,5.6-4.7C19.1,1.4,20.1,2.7,20,5.3L20,5.3z"/>
				</svg>
			'
		],

		'dtube' => [
			'name' => __( 'DTube', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="DTube Icon">
					<path d="M18.2,6c-0.4-1.2-1.1-2.3-1.9-3.2c-0.8-0.9-1.8-1.6-2.9-2C12.3,0.2,11,0,9.6,0H1.1v20h8.2c1.3,0,2.4-0.2,3.4-0.5c1-0.3,1.9-0.8,2.7-1.4c1.1-0.9,2-2,2.6-3.3c0.6-1.4,0.9-2.9,0.9-4.7C18.9,8.6,18.7,7.2,18.2,6z M6.1,14.5v-9l7.8,4.5L6.1,14.5z"/>
				</svg>
			'
		],

		'vk' => [
			'name' => __( 'VK', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="VKontakte Icon">
					<path d="M19.2,4.8H16c-0.3,0-0.5,0.1-0.6,0.4c0,0-1.3,2.4-1.7,3.2c-1.1,2.2-1.8,1.5-1.8,0.5V5.4c0-0.6-0.5-1.1-1.1-1.1H8.2C7.6,4.3,6.9,4.6,6.5,5.1c0,0,1.2-0.2,1.2,1.5c0,0.4,0,1.6,0,2.6c0,0.4-0.3,0.7-0.7,0.7c-0.2,0-0.4-0.1-0.6-0.2c-1-1.4-1.8-2.9-2.5-4.5C4,5,3.7,4.8,3.5,4.8c-0.7,0-2.1,0-2.9,0C0.2,4.8,0,5,0,5.3c0,0.1,0,0.1,0,0.2C0.9,8,4.8,15.7,9.2,15.7H11c0.4,0,0.7-0.3,0.7-0.7v-1.1c0-0.4,0.3-0.7,0.7-0.7c0.2,0,0.4,0.1,0.5,0.2l2.2,2.1c0.2,0.2,0.5,0.3,0.7,0.3h2.9c1.4,0,1.4-1,0.6-1.7c-0.5-0.5-2.5-2.6-2.5-2.6c-0.3-0.4-0.4-0.9-0.1-1.3c0.6-0.8,1.7-2.2,2.1-2.8C19.6,6.5,20.7,4.8,19.2,4.8z"/>
				</svg>
			',
		],

		'ok' => [
			'name' => __( 'Odnoklassniki', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Odnoklassniki Icon">
					<path d="M8.2,6.5c0-1,0.8-1.8,1.8-1.8s1.8,0.8,1.8,1.8c0,1-0.8,1.8-1.8,1.8S8.2,7.5,8.2,6.5L8.2,6.5z M20,2.1v15.7c0,1.2-1,2.1-2.1,2.1H2.1C1,20,0,19,0,17.9V2.1C0,1,1,0,2.1,0h15.7C19,0,20,1,20,2.1z M6.4,6.5c0,2,1.6,3.6,3.6,3.6s3.6-1.6,3.6-3.6c0-2-1.6-3.6-3.6-3.6S6.4,4.5,6.4,6.5z M14.2,10.5c-0.2-0.4-0.8-0.8-1.5-0.2c0,0-1,0.8-2.6,0.8s-2.6-0.8-2.6-0.8C6.6,9.8,6,10.1,5.8,10.5c-0.4,0.7,0,1.1,1,1.7c0.8,0.5,1.8,0.7,2.5,0.8l-0.6,0.6c-0.8,0.8-1.6,1.6-2.1,2.1c-0.8,0.8,0.5,2,1.3,1.3l2.1-2.1c0.8,0.8,1.6,1.6,2.1,2.1c0.8,0.8,2.1-0.5,1.3-1.3l-2.1-2.1l-0.6-0.6c0.7-0.1,1.7-0.3,2.5-0.8C14.1,11.6,14.5,11.2,14.2,10.5z"/>
				</svg>
			',
		],

		'rss' => [
			'name' => __( 'RSS', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="RSS Icon">
					<path d="M17.9,0H2.1C1,0,0,1,0,2.1v15.7C0,19,1,20,2.1,20h15.7c1.2,0,2.1-1,2.1-2.1V2.1C20,1,19,0,17.9,0z M5,17.1c-1.2,0-2.1-1-2.1-2.1s1-2.1,2.1-2.1s2.1,1,2.1,2.1S6.2,17.1,5,17.1z M12,17.1h-1.5c-0.3,0-0.5-0.2-0.5-0.5c-0.2-3.6-3.1-6.4-6.7-6.7c-0.3,0-0.5-0.2-0.5-0.5V8c0-0.3,0.2-0.5,0.5-0.5c4.9,0.3,8.9,4.2,9.2,9.2C12.6,16.9,12.3,17.1,12,17.1L12,17.1z M16.6,17.1h-1.5c-0.3,0-0.5-0.2-0.5-0.5c-0.2-6.1-5.1-11-11.2-11.2c-0.3,0-0.5-0.2-0.5-0.5V3.4c0-0.3,0.2-0.5,0.5-0.5c7.5,0.3,13.5,6.3,13.8,13.8C17.2,16.9,16.9,17.1,16.6,17.1L16.6,17.1z"/>
				</svg>
			'
		],

		'facebook_group' => [
			'name' => __( 'Facebook Group', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Facebook Group Icon">
					<path d="M3.3,18.4c-0.2-0.5,0.3-2.8,0.7-3.7c0.5-1.1,1.6-2,2.5-2.3c0.6-0.2,0.7-0.2,2.1,0.5l1.4,0.7l1.4-0.7c0.8-0.4,1.5-0.7,1.8-0.7c0.5,0,1.8,0.9,2.4,1.6c0.6,0.9,1.1,2.3,1.2,3.7l0,1.1l-6.7,0C4,18.7,3.4,18.6,3.3,18.4z M0.1,12.8c-0.4-0.9,0.6-3.4,1.6-4.1c0.8-0.5,1.5-0.5,2.5,0.1c0.6,0.4,0.9,0.5,1.1,0.3C5.6,9,5.7,9,5.9,9.3c0.2,0.2,0.6,0.6,0.9,1c0.6,0.6,0.6,0.7-0.4,1.1c-0.4,0.1-1.1,0.5-1.6,1l-0.9,0.7H2.1C0.5,13.1,0.2,13,0.1,12.8z M15.3,12.4c-0.4-0.4-1.1-0.8-1.5-1c-1.1-0.4-1.1-0.5-0.5-1.1c0.3-0.3,0.7-0.7,0.9-1C14.4,9,14.5,9,14.8,9.1c0.2,0.1,0.5,0,1.1-0.3c0.5-0.3,1.1-0.5,1.4-0.5c1.3,0,2.6,1.8,2.7,3.7l0,1l-2,0l-2,0L15.3,12.4z M8.4,10.6C7,9.9,6,8.4,6,6.9c0-2.1,2-4.1,4.1-4.1s4.1,2,4.1,4.1S12.1,11,10,11C9.6,11,8.9,10.8,8.4,10.6z M3.5,6.8c-1.7-1-1.9-3.5-0.4-4.7c1.1-0.9,2.5-1,3.6-0.2c1,0.7,1,0.9,0.2,1.6c-0.8,0.7-1.4,1.8-1.5,3C5.2,7.2,5.2,7.3,4.7,7.3C4.4,7.3,3.9,7.1,3.5,6.8z M14.8,6.5c-0.2-1.2-0.7-2.3-1.5-3c-0.8-0.7-0.8-0.9,0.2-1.6C15.4,0.6,18,2,18,4.3c0,1.5-1.4,3-2.7,3C14.9,7.3,14.9,7.2,14.8,6.5z"/>
				</svg>
			',
		],

		'facebook_messenger' => [
			'name' => __( 'Facebook Messenger', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Facebook Messenger Icon">
					<path d="M10,0C4.5,0,0.1,4.1,0.1,9.2c0,2.7,1.2,5.2,3.4,7V20l3.7-1.9c0.9,0.3,1.8,0.3,2.7,0.3c5.5,0,9.9-4.1,9.9-9.2C19.9,4.1,15.5,0,10,0z M11,12.3L8.5,9.6l-4.6,2.6L9,6.8l2.5,2.5l4.5-2.5L11,12.3z"/>
				</svg>
			',
		],

		'discord' => [
			'name' => __( 'Discord', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Discord Icon">
					<path d="M17.2,4.2c-1.7-1.4-4.5-1.6-4.6-1.6c-0.2,0-0.4,0.1-0.4,0.3c0,0-0.1,0.1-0.1,0.4c1.1,0.2,2.6,0.6,3.8,1.4C16.1,4.7,16.2,5,16,5.2c-0.1,0.1-0.2,0.2-0.4,0.2c-0.1,0-0.2,0-0.2-0.1C13.3,4,10.5,3.9,10,3.9S6.7,4,4.6,5.3C4.4,5.5,4.1,5.4,4,5.2C3.8,5,3.9,4.7,4.1,4.6c1.3-0.8,2.7-1.2,3.8-1.4C7.9,3,7.8,2.9,7.8,2.9C7.7,2.7,7.5,2.6,7.4,2.6c-0.1,0-2.9,0.2-4.6,1.7C1.8,5.1,0,10.1,0,14.3c0,0.1,0,0.2,0.1,0.2c1.3,2.2,4.7,2.8,5.5,2.8c0,0,0,0,0,0c0.1,0,0.3-0.1,0.4-0.2l0.8-1.1c-2.1-0.6-3.2-1.5-3.3-1.6c-0.2-0.2-0.2-0.4,0-0.6c0.2-0.2,0.4-0.2,0.6,0c0,0,2,1.7,6,1.7c4,0,6-1.7,6-1.7c0.2-0.2,0.5-0.1,0.6,0c0.2,0.2,0.1,0.5,0,0.6c-0.1,0.1-1.2,1-3.3,1.6l0.8,1.1c0.1,0.1,0.2,0.2,0.4,0.2c0,0,0,0,0,0c0.8,0,4.2-0.6,5.5-2.8c0-0.1,0.1-0.1,0.1-0.2C20,10.1,18.2,5.1,17.2,4.2z M7.2,12.6c-0.8,0-1.5-0.8-1.5-1.7s0.7-1.7,1.5-1.7c0.8,0,1.5,0.8,1.5,1.7S8,12.6,7.2,12.6z M12.8,12.6c-0.8,0-1.5-0.8-1.5-1.7s0.7-1.7,1.5-1.7c0.8,0,1.5,0.8,1.5,1.7S13.7,12.6,12.8,12.6z"/>
				</svg>
			',
		],

		'tripadvisor' => [
			'name' => __( 'TripAdvisor', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="TripAdvisor Icon">
					<path d="M5.9 10.7c0 .4-.4.8-.8.8s-.8-.4-.8-.8.4-.8.8-.8.8.3.8.8zm1.7 0c0 1.3-1.1 2.4-2.4 2.4S2.7 12 2.7 10.7c0-1.3 1.1-2.4 2.4-2.4s2.5 1 2.5 2.4zm-.9 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm8.2-.8c-.4 0-.8.4-.8.8s.4.8.8.8.8-.4.8-.8c0-.5-.4-.8-.8-.8zm2.4.8c0 1.3-1.1 2.4-2.4 2.4s-2.4-1.1-2.4-2.4c0-1.3 1.1-2.4 2.4-2.4s2.4 1 2.4 2.4zm-.8 0c0-.9-.7-1.6-1.6-1.6-.9 0-1.6.7-1.6 1.6 0 .9.7 1.6 1.6 1.6.9 0 1.6-.7 1.6-1.6zm1.6 4.1c-2.1 1.7-5.2 1.3-6.9-.8l-.9 1.5c0 .1-.1.1-.1.1-.2.1-.4.1-.6-.1L8.7 14c-1.7 2.1-4.7 2.5-6.9.8-2-1.7-2.4-4.8-.8-6.9-.1-.5-.4-1-.7-1.4 0-.1-.1-.2-.1-.3 0-.2.2-.4.4-.4h3.1c3.9-2.2 8.7-2.2 12.6 0h3.1c.1 0 .2 0 .3.1.2.1.2.4 0 .6-.3.4-.6.9-.8 1.4 1.7 2.1 1.3 5.2-.8 6.9zm-8.9-4.1c0-2.2-1.8-4.1-4.1-4.1h-1C2.3 7.1 1 8.8 1 10.7c0 2.2 1.9 4 4.1 4 2.3.1 4.1-1.8 4.1-4zm6.6-4h-.2c-.2 0-.5-.1-.7-.1-2.2 0-4 1.7-4.1 3.9 0 .7.2 1.4.5 2.1.1.1.1.2.2.3.8 1.1 2 1.8 3.4 1.8 1.9 0 3.5-1.3 3.9-3.1.5-2.1-.8-4.3-3-4.9z"/>
				</svg>
			',
		],

		'foursquare' => [
			'name' => __( 'Foursquare', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Foursquare Icon">
					<path d="M14.8 2.9l-.4 2.3c-.1.3-.4.5-.7.5H9.5c-.5 0-.8.4-.8.8V7c0 .5.3.8.8.8H13c.3 0 .7.4.6.7l-.4 2.3c0 .2-.3.5-.7.5H9.6c-.5 0-.7.1-1 .5-.3.4-3.5 4.2-3.5 4.2H5V2.8c0-.3.3-.6.6-.6h8.6c.4 0 .7.3.6.7zm.3 9.1c.1-.5 1.5-7.3 1.9-9.5M15.4 0H4.7C3.3 0 2.8 1.1 2.8 1.8v16.9c0 .8.4 1.1.7 1.2.2.1.9.2 1.3-.3 0 0 5-5.8 5.1-5.9.1-.1.1-.1.3-.1h3.3c1.4 0 1.6-1 1.7-1.5.1-.5 1.5-7.3 1.9-9.5C17.4.9 17 0 15.4 0z"/>
				</svg>
			',
		],

		'yelp' => [
			'name' => __( 'Yelp', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Yelp Icon">
					<path d="M18.8 14.4c0 .4-.3.8-.3.9l-2.1 2.9-.1.1c-.1 0-.5.3-1 .3s-1-.6-1.1-.7l-2.7-4.2c-.3-.3-.3-1 .1-1.5.3-.3.5-.3.9-.3h.3l5 1.5c.3.1 1 .3 1 1zm-6.1-3.3l5-1.4c.2-.1.9-.3 1-.9.2-.5-.1-1-.2-1 0 0 0-.1-.1-.1L16 5.2c0-.1-.3-.5-1-.5s-1 .6-1 .7l-2.8 4.2c-.2.3-.3.8 0 1.2.3.2.6.3 1.1.3h.4zM9.9.2C9.3 0 8.9 0 8.6.1L4.4 1.4c-.1 0-.5.2-.9.6-.4.8.4 1.6.4 1.6l4.4 5.5c.1.1.4.4 1 .4h.3c.7-.2 1-.9 1-1.3V1.6c-.1-.2-.2-1.1-.7-1.4zM8 12.6c.3-.1.7-.3.7-1.1s-.8-1.1-.9-1.2L3.4 8.2c-.1 0-1-.3-1.3-.1-.2.1-.7.5-.7.9l-.3 3.3c0 .2 0 .7.2 1 .1.2.3.4.8.4.3 0 .6-.1.6-.1l5.1-1c.2.1.2 0 .2 0zm1.8.3c-.2-.1-.3-.1-.4-.1-.5 0-1 .3-1 .4l-3.5 3.6c-.1.2-.5.8-.3 1.3.2.4.3.7.8.9l3.5 1h.4c.2 0 .3 0 .4-.1.5-.2.7-.8.7-1.2l.1-4.9c0-.2-.2-.7-.7-.9z"/>
				</svg>
			',
		],

		'hacker_news' => [
			'name' => __( 'Hacker News', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Hacker News Icon">
					<path d="M0,0v20h20V0H0z M11.2,11.8v4.7H8.8v-4.7L4.7,4.1h1.9l3.4,6l3.4-6h1.9L11.2,11.8z"/>
				</svg>
			',
		],

		'xing' => [
			'name' => __( 'Xing', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Xing Icon">
					<path d="M16.8,0H3.2C1.4,0,0,1.4,0,3.2v13.6C0,18.6,1.4,20,3.2,20h13.6c1.8,0,3.2-1.4,3.2-3.2V3.2C20,1.4,18.6,0,16.8,0z M6.2,13.3H3.8c-0.2,0-0.3-0.3-0.3-0.4L6,8.4c0.1-0.1,0.1-0.2,0-0.3L4.5,5.4C4.4,5.3,4.5,5,4.7,5H7c0.1,0,0.2,0.1,0.3,0.2L9,8.2c0.1,0.1,0.1,0.2,0,0.3l-2.6,4.7C6.4,13.2,6.2,13.3,6.2,13.3z M16.3,2.9l-4.7,8.6c-0.1,0.1-0.1,0.2,0,0.3l3,5.3c0.1,0.2,0,0.4-0.3,0.4h-2.3c-0.1,0-0.2-0.1-0.3-0.2l-3.2-5.6c-0.1-0.1-0.1-0.2,0-0.3l4.8-8.9c0.1,0,0.3-0.1,0.3-0.1h2.3C16.3,2.5,16.4,2.8,16.3,2.9z"/>
				</svg>
			'
		],

		'whatsapp' => [
			'name' => __( 'WhatsApp', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="WhatsApp Icon">
					<path d="M10,0C4.5,0,0,4.5,0,10c0,1.9,0.5,3.6,1.4,5.1L0.1,20l5-1.3C6.5,19.5,8.2,20,10,20c5.5,0,10-4.5,10-10S15.5,0,10,0zM6.6,5.3c0.2,0,0.3,0,0.5,0c0.2,0,0.4,0,0.6,0.4c0.2,0.5,0.7,1.7,0.8,1.8c0.1,0.1,0.1,0.3,0,0.4C8.3,8.2,8.3,8.3,8.1,8.5C8,8.6,7.9,8.8,7.8,8.9C7.7,9,7.5,9.1,7.7,9.4c0.1,0.2,0.6,1.1,1.4,1.7c0.9,0.8,1.7,1.1,2,1.2c0.2,0.1,0.4,0.1,0.5-0.1c0.1-0.2,0.6-0.7,0.8-1c0.2-0.2,0.3-0.2,0.6-0.1c0.2,0.1,1.4,0.7,1.7,0.8s0.4,0.2,0.5,0.3c0.1,0.1,0.1,0.6-0.1,1.2c-0.2,0.6-1.2,1.1-1.7,1.2c-0.5,0-0.9,0.2-3-0.6c-2.5-1-4.1-3.6-4.2-3.7c-0.1-0.2-1-1.3-1-2.6c0-1.2,0.6-1.8,0.9-2.1C6.1,5.4,6.4,5.3,6.6,5.3z"/>
				</svg>
			',
		],

		'flipboard' => [
			'name' => __( 'Flipboard', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Flipboard Icon">
					<path d="M0 0v20h20V0H0zm16 8h-4v4H8v4H4V4h12v4z"/>
				</svg>
			',
		],


		'viber' => [
			'name' => __( 'Viber', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Viber Icon">
					<path d="M18.6,4.4c-0.3-1.2-1-2.2-2-2.9c-1.2-0.9-2.7-1.2-3.9-1.4C11,0,9.4-0.1,8,0.1C6.6,0.3,5.5,0.6,4.6,1c-1.9,0.9-3,2.2-3.3,4.1C1.1,6,1,6.9,0.9,7.6c-0.2,1.8,0,3.4,0.4,4.9c0.4,1.5,1.2,2.5,2.2,3.2c0.3,0.2,0.6,0.3,1,0.4c0.2,0.1,0.3,0.1,0.5,0.2v2.9C5,19.7,5.3,20,5.7,20l0,0c0.2,0,0.4-0.1,0.5-0.2l2.7-2.6C9,17,9,17,9.1,17c0.9,0,1.9-0.1,2.8-0.1c1.1-0.1,2.5-0.2,3.7-0.7c1.1-0.5,2-1.2,2.5-2.2c0.5-1.1,0.8-2.2,0.9-3.5C19.3,8.2,19.1,6.2,18.6,4.4z M13.9,13.1c-0.3,0.4-0.7,0.8-1.2,1c-0.4,0.1-0.7,0.1-1.1,0C8.8,12.8,6.5,10.9,5,8.1C4.7,7.5,4.5,6.9,4.2,6.3C4.2,6.2,4.2,6,4.2,5.9c0-1,0.8-1.5,1.5-1.7c0.3-0.1,0.5,0,0.8,0.2c0.6,0.6,1.1,1.2,1.4,2C8,6.7,8,7,7.7,7.2C7.6,7.3,7.6,7.3,7.5,7.4C6.9,7.8,6.8,8.2,7.2,8.9c0.5,1.2,1.5,1.9,2.6,2.4c0.3,0.1,0.6,0.1,0.8-0.2c0,0,0.1-0.1,0.1-0.1c0.5-0.8,1.1-0.7,1.8-0.3c0.4,0.3,0.8,0.6,1.2,0.9C14.3,12.1,14.3,12.5,13.9,13.1z M10.4,5.1c-0.2,0-0.3,0-0.5,0C9.7,5.2,9.5,5,9.4,4.8c0-0.3,0.1-0.5,0.4-0.5c0.2,0,0.4-0.1,0.6-0.1c2.1,0,3.7,1.7,3.7,3.7c0,0.2,0,0.4-0.1,0.6c0,0.2-0.2,0.4-0.5,0.4c0,0-0.1,0-0.1,0c-0.3,0-0.4-0.3-0.4-0.5c0-0.2,0-0.3,0-0.5C13.2,6.4,12,5.1,10.4,5.1z M12.5,8.2c0,0.3-0.2,0.5-0.5,0.5s-0.5-0.2-0.5-0.5c0-0.8-0.6-1.4-1.4-1.4c-0.3,0-0.5-0.2-0.5-0.5c0-0.3,0.2-0.5,0.5-0.5C11.4,5.8,12.5,6.9,12.5,8.2zM15.7,8.8c-0.1,0.2-0.2,0.4-0.5,0.4c0,0-0.1,0-0.1,0c-0.3-0.1-0.4-0.3-0.4-0.6c0.1-0.3,0.1-0.6,0.1-0.9c0-2.3-1.9-4.2-4.2-4.2c-0.3,0-0.6,0-0.9,0.1C9.5,3.6,9.2,3.5,9.2,3.2C9.1,2.9,9.3,2.7,9.5,2.6c0.4-0.1,0.8-0.1,1.1-0.1c2.8,0,5.2,2.3,5.2,5.2C15.8,8,15.8,8.4,15.7,8.8z"/>
				</svg>
			',
		],

		'telegram' => [
			'name' => __( 'Telegram', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Telegram Icon">
					<path d="M19.9,3.1l-3,14.2c-0.2,1-0.8,1.3-1.7,0.8l-4.6-3.4l-2.2,2.1c-0.2,0.2-0.5,0.5-0.9,0.5l0.3-4.7L16.4,5c0.4-0.3-0.1-0.5-0.6-0.2L5.3,11.4L0.7,10c-1-0.3-1-1,0.2-1.5l17.7-6.8C19.5,1.4,20.2,1.9,19.9,3.1z"/>
				</svg>
			',
		],

		'line' => [
			'name' => __( 'Line', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20px"
				height="20px"
				viewBox="0 0 20 20"
				aria-label="Line Icon">
					<path d="M16.1 8.2c.3 0 .5.2.5.5s-.2.5-.5.5h-1.5v.9h1.5c.3 0 .5.2.5.5s-.2.5-.5.5h-2c-.3 0-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5h2c.3 0 .5.2.5.5s-.2.5-.5.5h-1.5V8h1.5zm-3.2 2.5c0 .2-.1.4-.4.5h-.2c-.2 0-.3-.1-.4-.2l-2-2.8v2.5c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-4c0-.2.1-.4.4-.5h.2c.2 0 .3.1.4.2L12 9.2V6.8c0-.3.2-.5.5-.5s.5.2.5.5v3.9zm-4.8 0c0 .3-.2.5-.5.5s-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5s.5.2.5.5v4zm-2 .6h-2c-.3 0-.5-.2-.5-.5v-4c0-.3.2-.5.5-.5s.5.2.5.5v3.5h1.5c.3 0 .5.2.5.5 0 .2-.2.5-.5.5M20 8.6C20 4.1 15.5.5 10 .5S0 4.1 0 8.6c0 4 3.6 7.4 8.4 8 .3.1.8.2.9.5.1.3.1.6 0 .9l-.1.9c0 .3-.2 1 .9.5 1.1-.4 5.8-3.4 7.9-5.8 1.3-1.6 2-3.2 2-5"/>
				</svg>
			',
		],

		'weibo' => [
			'name' => __( 'Weibo', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Weibo Icon">
					<path d="M15.9,7.6c0.3-0.9-0.5-1.8-1.5-1.6c-0.9,0.2-1.1-1.1-0.3-1.3c2-0.4,3.6,1.4,3,3.3C16.9,8.8,15.6,8.4,15.9,7.6z M8.4,18.1c-4.2,0-8.4-2-8.4-5.3C0,11,1.1,9,3,7.2c3.9-3.9,7.9-3.9,6.8-0.2c-0.2,0.5,0.5,0.2,0.5,0.2c3.1-1.3,5.5-0.7,4.5,2c-0.1,0.4,0,0.4,0.3,0.5C20.3,11.3,16.4,18.1,8.4,18.1L8.4,18.1zM14,12.4c-0.2-2.2-3.1-3.7-6.4-3.3C4.3,9.4,1.8,11.4,2,13.6s3.1,3.7,6.4,3.3C11.7,16.6,14.2,14.6,14,12.4zM13.6,2c-1,0.2-0.7,1.7,0.3,1.5c2.8-0.6,5.3,2.1,4.4,4.8c-0.3,0.9,1.1,1.4,1.5,0.5C21,4.9,17.6,1.2,13.6,2L13.6,2z M10.5,14.2c-0.7,1.5-2.6,2.3-4.3,1.8c-1.6-0.5-2.3-2.1-1.6-3.5c0.7-1.4,2.5-2.2,4-1.8C10.4,11.1,11.2,12.7,10.5,14.2zM7.2,13c-0.5-0.2-1.2,0-1.5,0.5C5.3,14,5.5,14.6,6,14.8c0.5,0.2,1.2,0,1.5-0.5C7.8,13.8,7.7,13.2,7.2,13zM8.4,12.5c-0.2-0.1-0.4,0-0.6,0.2c-0.1,0.2-0.1,0.4,0.1,0.5c0.2,0.1,0.5,0,0.6-0.2C8.7,12.8,8.6,12.6,8.4,12.5z"/>
				</svg>
			'
		],

		'tumblr' => [
			'name' => __( 'Tumblr', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Tumblr Icon">
					<path d="M18,0H2C0.9,0,0,0.9,0,2v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V2C20,0.9,19.1,0,18,0z M15,15.9c0,0,0,0.1-0.1,0.1c0,0-1.4,1-3.9,1c-3,0-3-3.6-3-4V9H6.2C6.1,9,6,8.9,6,8.8V7.2C6,7.1,6,7,6.1,7C6.1,7,9,5.7,9,3.2C9,3.1,9.1,3,9.2,3h1.7C10.9,3,11,3.1,11,3.2V7h2.8C13.9,7,14,7.1,14,7.2v1.7C14,8.9,13.9,9,13.8,9H11v4c0,0.1-0.1,1.3,1.2,1.3c1.1,0,2.5-0.3,2.5-0.3c0.1,0,0.1,0,0.2,0c0.1,0,0.1,0.1,0.1,0.2V15.9z"/>
				</svg>
			'
		],

		'qq' => [
			'name' => __( 'QQ', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="QQ Icon">
					<path d="M18.2,16.4c-0.5,0.1-1.8-2.1-1.8-2.1c0,1.2-0.6,2.8-2,4c0.7,0.2,2.1,0.7,1.8,1.3C16,20.2,11.3,20,10,19.8c-1.3,0.2-5.9,0.3-6.2-0.2c-0.4-0.6,1.1-1.1,1.8-1.3c-1.4-1.2-2-2.8-2-4c0,0-1.3,2.1-1.8,2.1c-0.2,0-0.5-1.2,0.4-3.9c0.4-1.3,0.9-2.4,1.6-4.1C3.6,3.8,5.5,0,10,0c4.4,0,6.4,3.8,6.3,8.4c0.7,1.8,1.2,2.8,1.6,4.1C18.7,15.3,18.4,16.4,18.2,16.4L18.2,16.4z"/>
				</svg>
			'
		],

		'wechat' => [
			'name' => __( 'WeChat', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="WeChat Icon">
					<path d="M13.5,6.8c0.2,0,0.5,0,0.7,0c-0.6-2.9-3.7-5-7.1-5C3.2,1.9,0,4.5,0,7.9c0,1.9,1.1,3.5,2.8,4.8l-0.7,2.1l2.5-1.2c0.9,0.2,1.6,0.4,2.5,0.4c0.2,0,0.4,0,0.7,0c-0.1-0.5-0.2-1-0.2-1.5C7.5,9.3,10.2,6.8,13.5,6.8L13.5,6.8zM9.7,4.9c0.5,0,0.9,0.4,0.9,0.9c0,0.5-0.4,0.9-0.9,0.9c-0.5,0-1.1-0.4-1.1-0.9C8.7,5.2,9.2,4.9,9.7,4.9zM4.8,6.6c-0.5,0-1.1-0.4-1.1-0.9c0-0.5,0.5-0.9,1.1-0.9c0.5,0,0.9,0.4,0.9,0.9C5.7,6.3,5.3,6.6,4.8,6.6z M20,12.3c0-2.8-2.8-5.1-6-5.1c-3.4,0-6,2.3-6,5.1s2.6,5.1,6,5.1c0.7,0,1.4-0.2,2.1-0.4l1.9,1.1l-0.5-1.8C18.9,15.3,20,13.9,20,12.3zM12,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C12.9,11.1,12.6,11.4,12,11.4zM15.9,11.4c-0.4,0-0.7-0.4-0.7-0.7c0-0.4,0.4-0.7,0.7-0.7c0.5,0,0.9,0.4,0.9,0.7C16.8,11.1,16.5,11.4,15.9,11.4z"/>
				</svg>
			'
		],

		'strava' => [
			'name' => __( 'Strava', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Strava Icon">
					<path d="M12.3,13.9l-1.4-2.7h2.8L12.3,13.9z M20,3v14c0,1.7-1.3,3-3,3H3c-1.7,0-3-1.3-3-3V3c0-1.7,1.3-3,3-3h14C18.7,0,20,1.3,20,3zM15.8,11.1h-2.1L9,2l-4.7,9.1H7L9,7.5l1.9,3.6H8.8l3.5,6.9L15.8,11.1z"/>
				</svg>
			'
		],

		'flickr' => [
			'name' => __( 'Flickr', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Flickr Icon">
					<path d="M4.7 14.7C2.1 14.8 0 12.6 0 10c0-2.5 2.1-4.7 4.8-4.7 2.6 0 4.7 2.1 4.7 4.8 0 2.6-2.2 4.7-4.8 4.6z"/>
					<path d="M15.3 5.3C18 5.3 20 7.5 20 10c0 2.6-2.1 4.7-4.7 4.7-2.5 0-4.7-2-4.7-4.7-.1-2.6 2-4.7 4.7-4.7z"/>
				</svg>
			'
		],

		'phone' => [
			'name' => __( 'Phone', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Phone Icon">
					<path d="M4.8,0C2.1,0,0,2.1,0,4.8v10.5C0,17.9,2.1,20,4.8,20h10.5c2.6,0,4.8-2.1,4.8-4.8V4.8C20,2.1,17.9,0,15.2,0H4.8z M6.7,3.8C7,3.8,7.2,4,7.4,4.3C7.6,4.6,7.9,5,8.3,5.6c0.3,0.5,0.4,1.2,0.1,1.8l-0.7,1C7.4,8.7,7.4,9,7.5,9.3c0.2,0.5,0.6,1.2,1.3,1.9c0.7,0.7,1.4,1.1,1.9,1.3c0.3,0.1,0.6,0.1,0.9-0.1l1-0.7c0.6-0.3,1.3-0.3,1.8,0.1c0.6,0.4,1.1,0.7,1.3,0.9c0.3,0.2,0.4,0.4,0.4,0.7c0.1,1.7-1.2,2.4-1.6,2.4c-0.3,0-3.4,0.4-7-3.2s-3.2-6.8-3.2-7C4.3,5.1,5,3.8,6.7,3.8z"/>
				</svg>
			'
		],

		'email' => [
			'name' => __( 'Email', 'blocksy' ),
			'icon' => '
				<svg
				class="ct-icon"
				width="20"
				height="20"
				viewBox="0 0 20 20"
				aria-label="Email Icon">
					<path d="M10,10.1L0,4.7C0.1,3.2,1.4,2,3,2h14c1.6,0,2.9,1.2,3,2.8L10,10.1z M10,11.8c-0.1,0-0.2,0-0.4-0.1L0,6.4V15c0,1.7,1.3,3,3,3h4.9h4.3H17c1.7,0,3-1.3,3-3V6.4l-9.6,5.2C10.2,11.7,10.1,11.7,10,11.8z"/>
				</svg>
			'
		],
	];

	foreach (blocksy_get_dynamic_social_networks() as $dynamic_network) {
		$metadata[$dynamic_network['id']] = [
			'name' => $dynamic_network['name'],
			'icon' => $dynamic_network['icon']
		];
	}

	if (! $args['social']) {
		return null;
	}

	if (! isset($metadata[$args['social']])) {
		return null;
	}

	$single_metadata = $metadata[$args['social']];
	$single_metadata['url'] = '';

	if ($args['type'] === 'url') {
		$single_metadata['url'] = get_theme_mod($args['social'], '#');

		if (empty(trim($single_metadata['url']))) {
			$single_metadata['url'] = '#';
		}
	}

	if ($args['type'] === 'share') {
		$home_url = blocksy_encode_uri_component(
			get_the_permalink()
		);

		if (! empty($args['custom_url'])) {
			$home_url = blocksy_encode_uri_component($args['custom_url']);
		}

		$social_urls = [
			'facebook' => 'https://www.facebook.com/sharer/sharer.php?u={url}',
			'twitter' => 'https://twitter.com/share?url={url}&text={text}',
			'pinterest' => '#',
			'linkedin' => 'https://www.linkedin.com/shareArticle?url={url}&title={text}',
			'reddit' => 'https://reddit.com/submit?url={url}&title={text}',
			'hacker_news' => 'https://news.ycombinator.com/submitlink?u={url}&t={text}',
			'vk' => 'http://vk.com/share.php?url={url}&title={text}',
			'ok' => 'https://connect.ok.ru/dk?st.cmd=WidgetSharePreview&st.shareUrl={url}',
			'telegram' => 'https://t.me/share/url?url={url}&text={text}',
			'viber' => 'viber://forward?text={url}',
			'whatsapp' => 'whatsapp://send?text={url}',
			'flipboard' => 'https://share.flipboard.com/bookmarklet/popout?v=2&title={text}&url={url}',
			'email' => 'mailto:?subject={text}&body={url}'
		];

		if (isset($social_urls[$args['social']])) {
			$single_metadata['url'] = str_replace(
				'{url}',
				$home_url,
				str_replace(
					'{text}',
					blocksy_encode_uri_component(get_the_title()),
					$social_urls[$args['social']]
				)
			);
		} else {
			$single_metadata['url'] = '#';
		}
	}

	return $single_metadata;
}
}

if (! function_exists('blocksy_get_social_share_items')) {
	function blocksy_get_social_share_items() {
		$prefix = blocksy_manager()->screen->get_prefix();

		return [
			[
				'id' => 'facebook',
				'enabled' => get_theme_mod(
					$prefix . '_share_facebook',
					'yes'
				) === 'yes',
			],

			[
				'id' => 'twitter',
				'enabled' => get_theme_mod(
					$prefix . '_share_twitter',
					'yes'
				) === 'yes',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_pinterest',
					'yes'
				) === 'yes',
				'id' => 'pinterest',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_linkedin',
					'yes'
				) === 'yes',
				'id' => 'linkedin',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_reddit',
					'no'
				) === 'yes',
				'id' => 'reddit',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_hacker_news',
					'no'
				) === 'yes',
				'id' => 'hacker_news',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_vk',
					'no'
				) === 'yes',
				'id' => 'vk',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_ok',
					'no'
				) === 'yes',
				'id' => 'ok',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_telegram',
					'no'
				) === 'yes',
				'id' => 'telegram',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_viber',
					'no'
				) === 'yes',
				'id' => 'viber',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_whatsapp',
					'no'
				) === 'yes',
				'id' => 'whatsapp',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_flipboard',
					'no'
				) === 'yes',
				'id' => 'flipboard',
			],

			[
				'enabled' => get_theme_mod(
					$prefix . '_share_email',
					'no'
				) === 'yes',
				'id' => 'email',
			],
		];
	}
}

if (! function_exists('blocksy_get_social_box')) {
function blocksy_get_social_box($args = []) {
	$args = wp_parse_args(
		$args,
		[
			// url | share
			'type' => 'url',
			'socials' => null,
			'attr' => [],
			'class' => '',
			'before_links_content' => '',

			'links_wrapper' => null,
			'links_wrapper_attr' => [],

			'after_links_content' => '',
			'has_count' => false,
			'hide_labels' => false,
			'root_class' => 'ct-social-box',
			'force_output' => false,
			'custom_share_url' => '',

			'links_target' => false,
			'links_rel' => false
		]
	);

	if ($args['type'] === 'share') {
		$args['socials'] = blocksy_get_social_share_items();
	}

	if ($args['socials'] === null) {
		$args['socials'] = [];

		foreach (blocksy_get_social_networks_list() as $network_id => $network) {
			$args['socials'][] = [
				'id' => $network_id,
				'enabled' => true
			];
		}
	}

	$has_any_social = 0;

	foreach ($args['socials'] as $single_social) {
		if (
			! isset($single_social['enabled'])
			|| (
				isset($single_social['enabled'])
				&&
				$single_social['enabled']
			) || $args['force_output']
		) {
			$has_any_social++;
		}
	}

	if (! $has_any_social) {
		return '';
	}

	$old_attr = [];

	$old_attr['class'] = $args['root_class'];

	if (! empty($args['class'])) {
		$old_attr['class'] .= ' ' . $args['class'];
	}

	if ($args['type'] === 'share') {
		// $old_attr['data-behavior'] = 'share';
	}

	if ($args['has_count']) {
		$old_attr['data-count'] = $has_any_social;
	}

	$old_attr = array_merge($old_attr, $args['attr']);

	$official_colors = [
		'facebook' => '#557dbc',
		'facebook_group' => '#3d87fb',
		'facebook_messenger' => '#1887FC',
		'discord' => '#7187d4',
		'tripadvisor' => '#40dfa3',
		'foursquare' => '#f84a7a',
		'yelp' => '#ca252a',
		'twitter' => '#7acdee',
		'instagram' => '#ed1376',
		'pinterest' => '#ea575a',
		'dribbble' => '#d77ea6',
		'behance' => '#1b64f6',
		'unsplash' => '#000000',
		'five-hundred-px' => '#000000',
		'linkedin' => '#1c86c6',
		'parler' => '#bc2131',
		'mastodon' => '#368ad2',
		'medium' => '#292929',
		'slack' => '#4e1850',
		'codepen' => '#000000',
		'reddit' => '#fc471e',
		'twitch' => '#9150fb',
		'tiktok' => '#000000',
		'snapchat' => '#f9d821',
		'spotify' => '#2ab859',
		'soundcloud' => '#fd561f',
		'apple_podcast' => '#933ac3',
		'patreon' => '#e65c4b',
		'alignable' => '#4a396f',
		'vk' => '#5382b6',
		'youtube' => '#e96651',
		'dtube' => '#233253',
		'vimeo' => '#8ecfde',
		'rss' => '#f09124',
		'whatsapp' => '#5bba67',
		'viber' => '#7f509e',
		'telegram' => '#229cce',
		'line' => '#20be60',
		'xing' => '#0a5c5d',
		'weibo' => '#e41c34',
		'tumblr' => '#314255',
		'qq' => '#487fc8',
		'wechat' => '#2dc121',
		'strava' => '#2dc121',
		'flickr' => '#0f64d1',
		'phone' => '#244371',
		'email' => '#392c44',
		'github' => '#24292e',
		'gitlab' => '#f8713f',
		'skype' => '#1caae7',
		'wordpress' => '#1074a8',
		'hacker_news' => '#fd6721',
		'ok' => '#eb7e2f',
		'flipboard' => '#c40812',
	];

	ob_start();

	?>

		<div <?php echo blocksy_attr_to_html($old_attr) ?>>
			<?php echo $args['before_links_content'] ?>

			<?php
				if ($args['links_wrapper']) {
					$result = $args['links_wrapper'];

					$result = trim($result . ' ' . blocksy_attr_to_html(
						$args['links_wrapper_attr']
					));

					echo '<' . $result . '>';
				}
			?>

			<?php foreach ($args['socials'] as $single_social) { ?>
				<?php
					if (! $single_social['enabled'] && !$args['force_output']) {
						continue;
					}

					$metadata = blocksy_get_social_metadata([
						'type' => $args['type'],
						'social' => $single_social['id'],
						'custom_url' => $args['custom_share_url']
					]);

					if (! $metadata) {
						continue;
					}

					$attr = [
						'href' => $metadata['url'],
						// 'target' => '_blank',
						'data-network' => $single_social['id'],
						'aria-label' => $metadata['name']
					];

					if (
						(
							(
								isset($args['links_wrapper_attr']['data-color'])
								&&
								$args['links_wrapper_attr']['data-color'] === 'official'
							) || (
								isset($old_attr['data-color'])
								&&
								$old_attr['data-color'] === 'official'
							)
						)
						&&
						isset($official_colors[$single_social['id']])
					) {
						$attr['style'] = "--official-color: " . $official_colors[
							$single_social['id']
						];
					}

					if ($args['links_target']) {
						$attr['target'] = $args['links_target'];
					}

					if ($args['links_rel']) {
						$attr['rel'] = $args['links_rel'];
					}

					if (isset($attr['rel'])) {
						$attr['rel'] = trim($attr['rel']);
					}

					$label_attr = ['class' => 'ct-label'];

					if ($args['hide_labels']) {
						$label_attr['hidden'] = '';
					}
				?>

				<a <?php echo blocksy_attr_to_html($attr) ?>>
					<?php
						// if ($args['type'] === 'share') {
						// 	echo $metadata['icon'];
						// }

						if (true || $args['type'] === 'url') {
							echo blocksy_html_tag(
								'span',
								[
									'class' => 'ct-icon-container'
								],
								$metadata['icon']
							);

							if ($args['type'] === 'url') {
								echo blocksy_html_tag(
									'span',
									$label_attr,
									$metadata['name']
								);
							}
						}
					?>
				</a>
			<?php } ?>

			<?php
				if ($args['links_wrapper']) {
					echo '</' . $args['links_wrapper'] . '>';
				}
			?>

			<?php echo $args['after_links_content'] ?>
		</div>

	<?php

	return ob_get_clean();
}
}

/**
 * Encore a string to be safely included in the URL.
 *
 * @param string $str String to encode for URL.
 */
if (! function_exists('blocksy_encode_uri_component')) {
	function blocksy_encode_uri_component( $str ) {
		$revert = [
			'%21' => '!',
			'%2A' => '*',
			'%27' => "'",
			'%28' => '(',
			'%29' => ')',
		];

		return strtr( rawurlencode( $str ), $revert );
	}
}

if (! function_exists('blocksy_get_social_networks_list')) {
	function blocksy_get_social_networks_list() {
		$networks = [
			'alignable' => [
				'label' => __( 'Alignable', 'blocksy' ),
			],

			'apple_podcast' => [
				'label' => __( 'Apple Podcasts', 'blocksy' ),
			],

			'behance' => [
				'label' => __( 'Behance', 'blocksy' ),
			],

			'codepen' => [
				'label' => __( 'CodePen', 'blocksy' ),
			],

			'dtube' => [
				'label' => __( 'DTube', 'blocksy' ),
			],

			'discord' => [
				'label' => __( 'Discord', 'blocksy' ),
			],

			'dribbble' => [
				'label' => __( 'Dribbble', 'blocksy' ),
			],

			'email' => [
				'label' => __( 'Email', 'blocksy' ),
			],

			'facebook' => [
				'label' => __( 'Facebook', 'blocksy' ),
			],

			'facebook_group' => [
				'label' => __( 'Facebook Group', 'blocksy' ),
			],

			'facebook_messenger' => [
				'label' => __( 'Facebook Messenger', 'blocksy' ),
			],

			'flickr' => [
				'label' => __( 'Flickr', 'blocksy' ),
			],

			'foursquare' => [
				'label' => __( 'Foursquare', 'blocksy' ),
			],

			'github' => [
				'label' => __( 'GitHub', 'blocksy' ),
			],

			'gitlab' => [
				'label' => __( 'GitLab', 'blocksy' ),
			],

			'instagram' => [
				'label' => __( 'Instagram', 'blocksy' ),
			],

			'line' => [
				'label' => __( 'Line', 'blocksy' ),
			],

			'linkedin' => [
				'label' => __( 'LinkedIn', 'blocksy' ),
			],

			'mastodon' => [
				'label' => __( 'Mastodon', 'blocksy' ),
			],

			'medium' => [
				'label' => __( 'Medium', 'blocksy' ),
			],

			'ok' => [
				'label' => __( 'Odnoklassniki', 'blocksy' ),
			],

			'parler' => [
				'label' => __( 'Parler', 'blocksy' ),
			],

			'patreon' => [
				'label' => __( 'Patreon', 'blocksy' ),
			],

			'phone' => [
				'label' => __( 'Phone', 'blocksy' ),
			],

			'pinterest' => [
				'label' => __( 'Pinterest', 'blocksy' ),
			],

			'qq' => [
				'label' => __( 'QQ', 'blocksy' ),
			],

			'rss' => [
				'label' => __( 'RSS', 'blocksy' ),
			],

			'reddit' => [
				'label' => __( 'Reddit', 'blocksy' ),
			],

			'skype' => [
				'label' => __( 'Skype', 'blocksy' ),
			],

			'slack' => [
				'label' => __( 'Slack', 'blocksy' ),
			],

			'snapchat' => [
				'label' => __( 'Snapchat', 'blocksy' ),
			],

			'soundcloud' => [
				'label' => __( 'SoundCloud', 'blocksy' ),
			],

			'spotify' => [
				'label' => __( 'Spotify', 'blocksy' ),
			],

			'strava' => [
				'label' => __( 'Strava', 'blocksy' ),
			],

			'telegram' => [
				'label' => __( 'Telegram', 'blocksy' ),
			],

			'tiktok' => [
				'label' => __( 'TikTok', 'blocksy' ),
			],

			'tripadvisor' => [
				'label' => __( 'TripAdvisor', 'blocksy' ),
			],

			'tumblr' => [
				'label' => __('Tumblr', 'blocksy'),
			],

			'twitch' => [
				'label' => __( 'Twitch', 'blocksy' ),
			],

			'twitter' => [
				'label' => __( 'Twitter', 'blocksy' ),
			],

			'unsplash' => [
				'label' => __( 'Unsplash', 'blocksy' ),
			],

			'vk' => [
				'label' => __( 'VK', 'blocksy' ),
			],

			'viber' => [
				'label' => __( 'Viber', 'blocksy' ),
			],

			'vimeo' => [
				'label' => __( 'Vimeo', 'blocksy' ),
			],

			'wechat' => [
				'label' => __( 'WeChat', 'blocksy' ),
			],

			'weibo' => [
				'label' => __( 'Weibo', 'blocksy' ),
			],

			'whatsapp' => [
				'label' => __( 'WhatsApp', 'blocksy' ),
			],

			'wordpress' => [
				'label' => __( 'WordPress', 'blocksy' ),
			],

			'xing' => [
				'label' => __( 'Xing', 'blocksy' ),
			],

			'yelp' => [
				'label' => __( 'Yelp', 'blocksy' ),
			],

			'youtube' => [
				'label' => __( 'YouTube', 'blocksy' ),
			],

			'five-hundred-px' => [
				'label' => __( '500px', 'blocksy' ),
			],
		];

		$dynamic_networks = blocksy_get_dynamic_social_networks();

		foreach ($dynamic_networks as $network) {
			$networks[$network['id']] = [
				'label' => $network['name']
			];
		}

		return $networks;
	}
}
