<?php
/**
 * Performance options
 *
 * @copyright 2019-present Creative Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Blocksy
 */

$options = [
	'performance_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [
			apply_filters(
				'blocksy_performance_end_customizer_options',
				[]
			),

			[
				'emoji_scripts' => [
					'label' => __( 'Disable Emojis Script', 'blocksy' ),
					'type' => 'ct-switch',
					'value' => 'yes',
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'Enable this option if you want to remove WordPress emojis script in order to improve the performance.', 'blocksy' )
				],

				blocksy_rand_md5() => [
					'type' => 'ct-divider'
				],

				'has_lazy_load' => [
					'label' => __( 'Lazy Load Images', 'blocksy' ),
					'type' => 'ct-switch',
					'value' => 'yes',
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'Enable lazy loading for images generated by Blocksy to improve performance.', 'blocksy' ),
				],

				blocksy_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_lazy_load' => 'yes' ],
					'options' => [

						'lazy_load_type' => [
							'label' => __( 'Images Loading Animation Type', 'blocksy' ),
							'type' => 'ct-radio',
							'value' => 'fade',
							'view' => 'text',
							'choices' => [
								'fade' => __( 'Fade', 'blocksy' ),
								'circle' => __( 'Circles', 'blocksy' ),
								'none' => __( 'None', 'blocksy' ),
							],
						],

					],
				],
			],
		],
	],
];
